/*
 * Decompiled with CFR 0.152.
 */
package com.dplayend.noenchantmentcaplevel.command;

import com.dplayend.noenchantmentcaplevel.command.CustomIntegerArgumentType;
import com.dplayend.noenchantmentcaplevel.handler.HandlerCommand;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import java.util.Collection;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7157;
import net.minecraft.class_7733;
import net.minecraft.class_7924;

public class EnchantmentCommand {
    private static final DynamicCommandExceptionType FAILED_ENTITY_EXCEPTION = new DynamicCommandExceptionType(entityName -> class_2561.method_54159((String)"commands.enchant.failed.entity", (Object[])new Object[]{entityName}));
    private static final DynamicCommandExceptionType FAILED_ITEMLESS_EXCEPTION = new DynamicCommandExceptionType(entityName -> class_2561.method_54159((String)"commands.enchant.failed.itemless", (Object[])new Object[]{entityName}));

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"setenchant").requires(source -> source.method_9259(2))).then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9306()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"enchantment", (ArgumentType)class_7733.method_45603((class_7157)registryAccess, (class_5321)class_7924.field_41265)).executes(context -> EnchantmentCommand.execute((class_2168)context.getSource(), class_2186.method_9317((CommandContext)context, (String)"targets"), (class_6880<class_1887>)class_7733.method_45612((CommandContext)context, (String)"enchantment"), 1))).then(class_2170.method_9244((String)"level", (ArgumentType)CustomIntegerArgumentType.integer()).executes(context -> EnchantmentCommand.execute((class_2168)context.getSource(), class_2186.method_9317((CommandContext)context, (String)"targets"), (class_6880<class_1887>)class_7733.method_45612((CommandContext)context, (String)"enchantment"), CustomIntegerArgumentType.getInteger(context, "level")))))));
    }

    private static int execute(class_2168 source, Collection<? extends class_1297> targets, class_6880<class_1887> enchantment, int level) throws CommandSyntaxException {
        for (class_1297 class_12972 : targets) {
            if (class_12972 instanceof class_1309) {
                class_1309 livingEntity = (class_1309)class_12972;
                class_1799 itemStack = livingEntity.method_6047();
                if (!itemStack.method_7960()) {
                    class_1890.method_57531((class_1799)itemStack, builder -> builder.method_57547(enchantment, level));
                    HandlerCommand.execute(itemStack, enchantment, level);
                    continue;
                }
                if (targets.size() != 1) continue;
                throw FAILED_ITEMLESS_EXCEPTION.create((Object)livingEntity.method_5477().getString());
            }
            if (targets.size() != 1) continue;
            throw FAILED_ENTITY_EXCEPTION.create((Object)class_12972.method_5477().getString());
        }
        if (!targets.isEmpty()) {
            if (targets.size() == 1) {
                source.method_9226(() -> class_2561.method_43469((String)"commands.enchant.success.single", (Object[])new Object[]{class_1887.method_8179((class_6880)enchantment, (int)level), ((class_1297)targets.iterator().next()).method_5476()}), true);
            } else {
                source.method_9226(() -> class_2561.method_43469((String)"commands.enchant.success.multiple", (Object[])new Object[]{class_1887.method_8179((class_6880)enchantment, (int)level), targets.size()}), true);
            }
        }
        return 0;
    }
}

